/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.rs232;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionRs232
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.rs232.Resources";
    private boolean loggingOn = false;

    public ActionRs232() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionRs232");
                System.out.println("Interface = " + objectArray[0]);
                System.out.println("ifAdminStatus = " + statusModelInfo.get("Panel.IfAdminStatus"));
                System.out.println("ifOperStatus  = " + statusModelInfo.get("Panel.IfOperStatus"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.IfAdminStatus"), (Integer)statusModelInfo.get("Panel.IfOperStatus"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, int n2, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        switch (n) {
            case 1: {
                if (n2 == 1) {
                    statusAndExplain.statType = StatusType.NORMAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "NORMAL", objectArray);
                    break;
                }
                if (n2 == 2) {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "DOWN", objectArray);
                    break;
                }
                if (n2 == 3) {
                    statusAndExplain.statType = StatusType.UNKNOWN;
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "TESTING", objectArray);
                    break;
                }
                statusAndExplain.statType = StatusType.UNKNOWN;
                if (n2 == 5) {
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "DORMANT", objectArray);
                    break;
                }
                if (n2 == 4) {
                    statusAndExplain.explain = new I18NMsgFormat(bundleName, "UNKNOWN", objectArray);
                    break;
                }
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "UNEXPECTED_IFOPER", objectArray);
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ADMIN_DOWN", objectArray);
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "TESTING", objectArray);
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "UNEXPECTED_IFADMIN", objectArray);
            }
        }
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NMsgFormat explain;

        StatusAndExplain() {
            ActionRs232.this = ActionRs232.this;
        }
    }
}

